set verify off
set echo off
set define "&"

--Filename		:  	dw_batch_activity_report.sql
--Release 		:  	STORET c2.0.5
--SIR			:  	1720
--Description	:  	Batch activity report for the time duration provided by the From_date and To_date bind variables.
--Author          :	Ganesh Thadkamalla
--Date		: 	August 18, 2005
--Comments		:  	Please provide values for the bind vairables FROM_DATE and TO_DATE while running the report.

-- Please update the following variable values appropriately.  The format should be 'DD-MON-YYYY'.
Prompt STORET Central Warehouse Batch Activity Report
PROMPT Please provide the start date for the report using format 'DD-MON-YYYY'
DEFINE FROM_DATE=&FromDate
PROMPT Please provide the end date for the report using format 'DD-MON-YYYY'
DEFINE TO_DATE=&ToDate
--DEFINE FROM_DATE='15-AUG-2005'
--DEFINE TO_DATE='19-AUG-2005'
--SQL plus variables.
set linesize 1000
set trimspool on
set pagesize 10000
set echo off
set define "&"
set verify off
set heading off


spool dw_batch_activity_report.log
prompt     STORET Central Warehouse Batch Activity Report
prompt                Duration : &FROM_DATE - &TO_DATE 
Prompt ---------------------------------------------------------

Prompt REQUEST_ID~REQUEST_TYPE~DATETIME~FILESIZE_KB~F_STATE~F_COUNTY~F_LATLONG~F_HUC~F_STATIONTYPE~F_CHARACTERISTIC~F_ORGANIZATION~F_STATION~F_ACT_STARTDATE~F_ACT_MEDIUM~F_PROJECT~F_ACT_INTENT~F_COMMUNITY_SAMPLED~REQUEST_MODE~REQUEST_STATUS~EMAIL_ADDRESS~NOTIFIED~FILENAME~RECORD_COUNT~PROCESSED_DATE

select REQUEST_ID||'~'||REQUEST_TYPE||'~'||DATETIME||'~'||FILESIZE_KB||'~'||
  F_STATE||'~'||F_COUNTY||'~'||F_LATLONG||'~'||F_HUC||'~'||F_STATIONTYPE||'~'||
  F_CHARACTERISTIC||'~'||F_ORGANIZATION||'~'||F_STATION||'~'||F_ACT_STARTDATE||'~'||
  F_ACT_MEDIUM||'~'||F_PROJECT||'~'||F_ACT_INTENT||'~'||F_COMMUNITY_SAMPLED||'~'||
  REQUEST_MODE||'~'||REQUEST_STATUS||'~'||EMAIL_ADDRESS||'~'||NOTIFIED||'~'||
  FILENAME||'~'||RECORD_COUNT||'~'||PROCESSED_DATE
from dw_data_requests
where REQUEST_MODE IN ('Immediate','Overnight')
AND   trunc(datetime) between to_date('&FROM_DATE','DD-MON-YYYY') AND TO_DATE('&TO_DATE','DD-MON-YYYY')
ORDER BY REQUEST_ID;


spool off;

